###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for udev MDVA-2008:084 (udev)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830411);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:084");
  script_cve_id("");
  script_name(english: "Mandriva Update for udev MDVA-2008:084 (udev)");
  desc["english"] = "

  Vulnerability Insight:

  The udev rules for network interfaces used to write persistent
  settings for hso devices in /etc/udev/rules.d/61-net_config.rules,
  which is wrong since their MAC address is random (#39977).
  
  The udev rules for automatic driver loading used to load video drivers
  during the dkms service start, which could break Xorg start if the
  loaded driver was not configured.
  
  This update fixes both issues.

  Affected Software/OS:
  udev on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00005.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of udev");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libvolume_id0-118", rpm:"libvolume_id0-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libvolume_id0-devel-118", rpm:"libvolume_id0-devel-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"udev-118", rpm:"udev-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"udev-doc-118", rpm:"udev-doc-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"udev-tools-118", rpm:"udev-tools-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64volume_id0-118", rpm:"lib64volume_id0-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64volume_id0-devel-118", rpm:"lib64volume_id0-devel-118~6.2mnb1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}