###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for drakxtools MDVA-2008:074 (drakxtools)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830373);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:074");
  script_cve_id("");
  script_name(english: "Mandriva Update for drakxtools MDVA-2008:074 (drakxtools)");
  desc["english"] = "

  Vulnerability Insight:

  This update fixes a few minor issues with draksound:
  - it greys PulseAudio options in the GUI if PulseAudio is disabled
  - it disables PulseAudio routing when PulseAudio is disabled (bug
  #40219)

  Affected Software/OS:
  drakxtools on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00034.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of drakxtools");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"drakx-finish-install", rpm:"drakx-finish-install~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"drakxtools", rpm:"drakxtools~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"drakxtools-backend", rpm:"drakxtools-backend~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"drakxtools-curses", rpm:"drakxtools-curses~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"drakxtools-http", rpm:"drakxtools-http~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"harddrake", rpm:"harddrake~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"harddrake-ui", rpm:"harddrake-ui~10.29.5~1.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}