###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for konqueror MDKSA-2007:176 (konqueror)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830171);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:176");
  script_cve_id("CVE-2007-3820", "CVE-2007-4224", "CVE-2007-4225");
  script_name(english: "Mandriva Update for konqueror MDKSA-2007:176 (konqueror)");
  desc["english"] = "

  Vulnerability Insight:

  konqueror/konq_combo.cc in Konqueror 3.5.7 allows remote attackers
  to spoof the data: URI scheme in the address bar via a long URI with
  trailing whitespace, which prevents the beginning of the URI from
  being displayed. (CVE-2007-3820)
  
  KDE Konqueror 3.5.7 allows remote attackers to spoof the URL address
  bar by calling setInterval with a small interval and changing the
  window.location property. (CVE-2007-4224)
  
  Visual truncation vulnerability in KDE Konqueror 3.5.7 allows remote
  attackers to spoof the URL address bar via an http URI with a large
  amount of whitespace in the user/password portion. (CVE-2007-4225)
  
  Updated packages fix these issues.

  Affected Software/OS:
  konqueror on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-09/msg00004.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of konqueror");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"kdebase", rpm:"kdebase~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-common", rpm:"kdebase-common~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kate", rpm:"kdebase-kate~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kdeprintfax", rpm:"kdebase-kdeprintfax~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kdm", rpm:"kdebase-kdm~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kmenuedit", rpm:"kdebase-kmenuedit~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-konsole", rpm:"kdebase-konsole~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-nsplugins", rpm:"kdebase-nsplugins~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-progs", rpm:"kdebase-progs~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-session-plugins", rpm:"kdebase-session-plugins~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs-common", rpm:"kdelibs-common~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs-devel-doc", rpm:"kdelibs-devel-doc~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4", rpm:"libkdebase4~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-devel", rpm:"libkdebase4-devel~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-kate", rpm:"libkdebase4-kate~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-kate-devel", rpm:"libkdebase4-kate-devel~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-kmenuedit", rpm:"libkdebase4-kmenuedit~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-konsole", rpm:"libkdebase4-konsole~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore4", rpm:"libkdecore4~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore4-devel", rpm:"libkdecore4-devel~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs", rpm:"kdelibs~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4", rpm:"lib64kdebase4~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-devel", rpm:"lib64kdebase4-devel~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-kate", rpm:"lib64kdebase4-kate~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-kate-devel", rpm:"lib64kdebase4-kate-devel~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-kmenuedit", rpm:"lib64kdebase4-kmenuedit~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-konsole", rpm:"lib64kdebase4-konsole~3.5.6~34.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore4", rpm:"lib64kdecore4~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore4-devel", rpm:"lib64kdecore4-devel~3.5.6~11.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kdebase", rpm:"kdebase~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-common", rpm:"kdebase-common~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kate", rpm:"kdebase-kate~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kdeprintfax", rpm:"kdebase-kdeprintfax~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kdm", rpm:"kdebase-kdm~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-kmenuedit", rpm:"kdebase-kmenuedit~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-konsole", rpm:"kdebase-konsole~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-nsplugins", rpm:"kdebase-nsplugins~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase-progs", rpm:"kdebase-progs~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs-common", rpm:"kdelibs-common~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs-devel-doc", rpm:"kdelibs-devel-doc~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4", rpm:"libkdebase4~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-devel", rpm:"libkdebase4-devel~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-kate", rpm:"libkdebase4-kate~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-kate-devel", rpm:"libkdebase4-kate-devel~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-kmenuedit", rpm:"libkdebase4-kmenuedit~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdebase4-konsole", rpm:"libkdebase4-konsole~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore4", rpm:"libkdecore4~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore4-devel", rpm:"libkdecore4-devel~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs", rpm:"kdelibs~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4", rpm:"lib64kdebase4~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-devel", rpm:"lib64kdebase4-devel~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-kate", rpm:"lib64kdebase4-kate~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-kate-devel", rpm:"lib64kdebase4-kate-devel~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-kmenuedit", rpm:"lib64kdebase4-kmenuedit~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdebase4-konsole", rpm:"lib64kdebase4-konsole~3.5.4~35.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore4", rpm:"lib64kdecore4~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore4-devel", rpm:"lib64kdecore4-devel~3.5.4~19.6mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}