###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for postgresql MDKSA-2007:094 (postgresql)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830250);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:094");
  script_cve_id("CVE-2007-2138");
  script_name(english: "Mandriva Update for postgresql MDKSA-2007:094 (postgresql)");
  desc["english"] = "

  Vulnerability Insight:

  A weakness in previous versions of PostgreSQL was found in the security
  definer functions in which an authenticated but otherwise unprivileged
  SQL user could use temporary objects to execute arbitrary code with
  the privileges of the security-definer function.
  
  IMPORTANT NOTICE FOR CORPORATE SERVER/DESKTOP 3.0 USERS:
  
  In addition, packages for Corporate Server/Desktop 3.0 have been
  updated to the latest PostgreSQL 7.4.17 which requires some attention
  when upgrading.  To take advantage of the new version, and to ensure
  data coherency, we strongly recommend dumping the old databases,
  re-initializing the database, and then reloading the dumped data.
  This can be accomplished as root using:
  
  # service postgresql start
  # su - postgres
  $ pg_dumpall &gt;/tmp/database.dump
  $ exit
  # service postgresql stop
  # mv /var/lib/pgsql /var/lib/pgsql.bk
  # urpmi.update -a &amp;&amp; urpmi --auto-select
  # service postgresql start
  # service postgresql restart
  # su - postgres
  $ /usr/bin/psql -d template1 -f /tmp/database.dump
  $ exit
  
  Only Corporate Server/Desktop 3.0 requires the dump/reload steps; the
  other Mandriva Linux platforms do not require this step.  Notice that
  the double-restart of the postgresql service is in fact required.
  
  Updated packages have been patched to correct this issue.

  Affected Software/OS:
  postgresql on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00033.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5-devel", rpm:"libecpg5-devel~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq5", rpm:"libpq5~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq5-devel", rpm:"libpq5-devel~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpgsql", rpm:"postgresql-plpgsql~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5-devel", rpm:"lib64ecpg5-devel~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq5", rpm:"lib64pq5~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq5-devel", rpm:"lib64pq5-devel~8.2.4~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5-devel", rpm:"libecpg5-devel~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4", rpm:"libpq4~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4-devel", rpm:"libpq4-devel~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpgsql", rpm:"postgresql-plpgsql~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5-devel", rpm:"lib64ecpg5-devel~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4", rpm:"lib64pq4~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4-devel", rpm:"lib64pq4-devel~8.1.9~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}