###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for krb5 MDKSA-2007:077-1 (krb5)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830144);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:077-1");
  script_cve_id("CVE-2007-0956", "CVE-2007-0957", "CVE-2007-1216");
  script_name(english: "Mandriva Update for krb5 MDKSA-2007:077-1 (krb5)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was found in the username handling of the MIT krb5
  telnet daemon.  A remote attacker that could access the telnet port
  of a target machine could login as root without requiring a password
  (CVE-2007-0956).
  
  Buffer overflows in the kadmin server daemon were discovered that could
  be exploited by a remote attacker able to access the KDC.  Successful
  exploitation could allow for the execution of arbitrary code with
  the privileges of the KDC or kadmin server processes (CVE-2007-0957).
  
  Finally, a double-free flaw was discovered in the GSSAPI library used
  by the kadmin server daemon, which could lead to a denial of service
  condition or the execution of arbitrary code with the privileges of
  the KDC or kadmin server processes (CVE-2007-1216).
  
  Updated packages have been patched to address this issue.
  
  Update:
  
  Packages for Mandriva Linux 2007.1 are now available.

  Affected Software/OS:
  krb5 on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00010.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"ftp-client-krb5", rpm:"ftp-client-krb5~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ftp-server-krb5", rpm:"ftp-server-krb5~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-workstation", rpm:"krb5-workstation~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53", rpm:"libkrb53~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrb53-devel", rpm:"libkrb53-devel~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-client-krb5", rpm:"telnet-client-krb5~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"telnet-server-krb5", rpm:"telnet-server-krb5~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53", rpm:"lib64krb53~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krb53-devel", rpm:"lib64krb53-devel~1.5.2~6.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}