###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for openafs MDKSA-2007:066 (openafs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830206);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:066");
  script_cve_id("CVE-2007-1507");
  script_name(english: "Mandriva Update for openafs MDKSA-2007:066 (openafs)");
  desc["english"] = "

  Vulnerability Insight:

  By default, OpenAFS prior to 1.44 and 1.5.17 supports setuid programs
  within the local cell, which could allow attackers to obtain privileges.
  
  Updated packages have been patched to address this issue.

  Affected Software/OS:
  openafs on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00021.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openafs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"dkms-libafs", rpm:"dkms-libafs~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopenafs1", rpm:"libopenafs1~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopenafs1-devel", rpm:"libopenafs1-devel~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs", rpm:"openafs~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-client", rpm:"openafs-client~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-doc", rpm:"openafs-doc~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-server", rpm:"openafs-server~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64openafs1", rpm:"lib64openafs1~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64openafs1-devel", rpm:"lib64openafs1-devel~1.4.1~5.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}