###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDKSA-2007:060 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830322);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:060");
  script_cve_id("CVE-2006-4538", "CVE-2006-4814", "CVE-2006-5753", "CVE-2006-5823", "CVE-2006-6053", "CVE-2006-6056", "CVE-2007-0006", "CVE-2007-0772", "CVE-2004-1073", "CVE-2007-0958");
  script_name(english: "Mandriva Update for kernel MDKSA-2007:060 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  Some vulnerabilities were discovered and corrected in the Linux 2.6
  kernel:
  
  The 2.6.17 kernel and earlier, when running on IA64 and SPARC platforms
  would allow a local user to cause a DoS (crash) via a malformed ELF file
  (CVE-2006-4538).
  
  The mincore function in the Linux kernel did not properly lock access to
  user space, which has unspecified impact and attack vectors, possibly
  related to a deadlock (CVE-2006-4814).
  
  An unspecified vulnerability in the listxattr system call, when a &quot;bad
  inode&quot; is present, could allow a local user to cause a DoS (data
  corruption) and possibly gain privileges via unknown vectors
  (CVE-2006-5753).
  
  The zlib_inflate function allows local users to cause a crash via a
  malformed filesystem that uses zlib compression that triggers memory
  corruption (CVE-2006-5823).
  
  The ext3fs_dirhash function could allow local users to cause a DoS
  (crash) via an ext3 stream with malformed data structures
  (CVE-2006-6053).
  
  When SELinux hooks are enabled, the kernel could allow a local user to
  cause a DoS (crash) via a malformed file stream that triggers a NULL
  pointer derefernece (CVE-2006-6056).
  
  The key serial number collision avoidance code in the key_alloc_serial
  function in kernels 2.6.9 up to 2.6.20 allows local users to cause a
  crash via vectors thatr trigger a null dereference (CVE-2007-0006).
  
  The Linux kernel version 2.6.13 to 2.6.20.1 allowed a remote attacker
  to cause a DoS (oops) via a crafted NFSACL2 ACCESS request that
  triggered a free of an incorrect pointer (CVE-2007-0772).
  
  A local user could read unreadable binaries by using the interpreter
  (PT_INTERP) functionality and triggering a core dump; a variant of
  CVE-2004-1073 (CVE-2007-0958).
  
  The provided packages are patched to fix these vulnerabilities.  All
  users are encouraged to upgrade to these updated kernels immediately
  and reboot to effect the fixes.
  
  In addition to these security fixes, other fixes have been included
  such as:
  
  - add PCI IDs for cciss driver (HP ML370G5 / DL360G5)
  - fixed a mssive SCSI reset on megasas (Dell PE2960)
  - increased port-reset completion delay for HP controllers (HP ML350)
  - NUMA rnage fixes for x86_64
  - various netfilter fixes
  
  To update your kernel, please follow the directions located at:
  
  http://www.mandriva.com/en/security/kernelupdate

  Affected Software/OS:
  kernel on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00013.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-BOOT", rpm:"kernel-BOOT~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-i586-up-1GB", rpm:"kernel-i586-up-1GB~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-i686-up-4GB", rpm:"kernel-i686-up-4GB~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xbox", rpm:"kernel-xbox~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.12.31mdk~1~1mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}