###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mozilla-firefox MDKSA-2007:050-1 (mozilla-firefox)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830145);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:050-1");
  script_cve_id("CVE-2006-6077", "CVE-2007-0008", "CVE-2007-0009", "CVE-2007-0775", "CVE-2007-0777", "CVE-2007-0778", "CVE-2007-0779", "CVE-2007-0780", "CVE-2007-0800", "CVE-2007-0981", "CVE-2007-0995", "CVE-2007-0996", "CVE-2007-1092");
  script_name(english: "Mandriva Update for mozilla-firefox MDKSA-2007:050-1 (mozilla-firefox)");
  desc["english"] = "

  Vulnerability Insight:

  A number of security vulnerabilities have been discovered and corrected
  in the latest Mozilla Firefox program, version 1.5.0.10.
  
  This update provides the latest Firefox to correct these issues.
  
  Update:
  
  A regression was found in the latest Firefox packages provided where
  changes to library paths caused applications that depended on the NSS
  libraries (such as Thunderbird and Evolution) to fail to start or fail
  to load certain SSL-related security components.  These new packages
  correct that problem and we apologize for any inconvenience the
  previous update may have caused.

  Affected Software/OS:
  mozilla-firefox on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00003.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mozilla-firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libmozilla-firefox1.5.0.10", rpm:"libmozilla-firefox1.5.0.10~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmozilla-firefox1.5.0.10-devel", rpm:"libmozilla-firefox1.5.0.10-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnspr4", rpm:"libnspr4~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnspr4-devel", rpm:"libnspr4-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnspr4-static-devel", rpm:"libnspr4-static-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnss3", rpm:"libnss3~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnss3-devel", rpm:"libnss3-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox", rpm:"mozilla-firefox~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox1.5.0.10", rpm:"lib64mozilla-firefox1.5.0.10~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox1.5.0.10-devel", rpm:"lib64mozilla-firefox1.5.0.10-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nspr4", rpm:"lib64nspr4~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nspr4-devel", rpm:"lib64nspr4-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nspr4-static-devel", rpm:"lib64nspr4-static-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nss3", rpm:"lib64nss3~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nss3-devel", rpm:"lib64nss3-devel~1.5.0.10~2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}