###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for spamassassin MDKSA-2007:049 (spamassassin)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830211);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:049");
  script_cve_id("CVE-2007-0451");
  script_name(english: "Mandriva Update for spamassassin MDKSA-2007:049 (spamassassin)");
  desc["english"] = "

  Vulnerability Insight:

  A bug in the way that SpamAssassin processes HTML emails containing
  URIs was discovered in versions 3.1.x.  A carefully crafted mail
  message could make SpamAssassin consume significant amounts of CPU
  resources that could delay or prevent the delivery of mail if a
  number of these messages were sent at once.
  
  SpamAssassin has been upgraded to version 3.1.8 to correct this
  problem, and other upstream bugs.  In addition, an invalid path setting
  in local.cf for the auto_whitelist_path has been fixed for Mandriva
  2007.0.

  Affected Software/OS:
  spamassassin on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00020.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of spamassassin");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"perl-Mail-SpamAssassin", rpm:"perl-Mail-SpamAssassin~3.1.8~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin", rpm:"spamassassin~3.1.8~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamc", rpm:"spamassassin-spamc~3.1.8~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-spamd", rpm:"spamassassin-spamd~3.1.8~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"spamassassin-tools", rpm:"spamassassin-tools~3.1.8~0.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}