###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libgtop2 MDKSA-2007:023 (libgtop2)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830087);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:023");
  script_cve_id("CVE-2007-0235");
  script_name(english: "Mandriva Update for libgtop2 MDKSA-2007:023 (libgtop2)");
  desc["english"] = "

  Vulnerability Insight:

  Stack-based buffer overflow in the glibtop_get_proc_map_s function in
  libgtop before 2.14.6 (libgtop2) allows local users to cause a denial
  of service (crash) and possibly execute arbitrary code via a process
  with a long filename that is mapped in its address space, which
  triggers the overflow in gnome-system-monitor.
  
  The updated packages have been patched to correct this problem.

  Affected Software/OS:
  libgtop2 on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00033.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libgtop2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libgtop2", rpm:"libgtop2~2.14.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtop2.0_7", rpm:"libgtop2.0_7~2.14.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtop2.0_7-devel", rpm:"libgtop2.0_7-devel~2.14.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtop2.0_7", rpm:"lib64gtop2.0_7~2.14.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtop2.0_7-devel", rpm:"lib64gtop2.0_7-devel~2.14.3~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}