###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for bluez-utils MDKSA-2007:014 (bluez-utils)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830165);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:014");
  script_cve_id("CAN-2006-6899");
  script_name(english: "Mandriva Update for bluez-utils MDKSA-2007:014 (bluez-utils)");
  desc["english"] = "

  Vulnerability Insight:

  hidd in BlueZ (bluez-utils) before 2.25 allows remote attackers to
  obtain control of the (1) Mouse and (2) Keyboard Human Interface Device
  (HID) via a certain configuration of two HID (PSM) endpoints, operating
  as a server, aka HidAttack.
  
  hidd is not enabled by default on Mandriva 2006.0. This update adds the
  --nocheck option (disabled by default) to the hidd binary, which
  defaults to rejecting connections from unknown devices unless --nocheck
  is enabled.
  
  The updated packages have been patched to correct this problem

  Affected Software/OS:
  bluez-utils on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00023.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bluez-utils");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~2.19~7.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bluez-utils-cups", rpm:"bluez-utils-cups~2.19~7.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}