###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ktorrent_sec_bypass_vuln.nasl 850 2009-01-20 11:36:24Z jan $
#
# KTorrent PHP Code Injection And Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800342);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5905", "CVE-2008-5906");
  script_bugtraq_id(31927);
  script_name(english:"KTorrent PHP Code Injection And Security Bypass Vulnerability");
  desc["english"] = "

  Overview: This host has KTorrent installed and is prone to Security Bypass
  vulnerability.

  Vulnerability Insight:
  The flaws are caused due to,
  - sending improperly sanitised request into PHP interpreter. This can be
    exploited by injecting PHP code.
  - web interface plugin does not properly restrict access to the torrent
    upload functionality via HTTP POST request.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary PHP
  code and also bypass security restriction when affected web interface plugin
  is enabled.

  Impact Level: System

  Affected Software/OS:
  KTorrent version prior to 3.1.4 on Linux.

  Fix: Upgade to 3.1.4 or higher version
  http://ktorrent.org/

  References:
  http://secunia.com/advisories/32442
  https://bugs.gentoo.org/show_bug.cgi?id=244741
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=504178

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of KTorrent");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("gb_ktorrent_detect.nasl");
  script_require_keys("KTorrent/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ktVer = get_kb_item("KTorrent/Linux/Ver");
if(!ktVer){
  exit(0);
}

# Check for version prior to 3.1.4
if(version_is_less(version:ktVer, test_version:"3.1.4")){
  security_warning(0);
}
