###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_incredimail_dos_vuln.nasl 669 2008-12-17 17:13:15Z dec $
#
# Incredimail Malformed MIME Message DoS Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800085);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5429");
  script_name(english:"Incredimail Malformed MIME Message DoS Vulnerability");
  desc["english"] = "

  Overview: This host has Incredimail installed and is prone to denial of
  service vulnerability.

  Vulnerability Insight:
  Flaw is caused due to improper handling of multipart/mixed e-mail messages
  with many MIME parts and e-mail messages with many Content-type: message/rfc822
  headers.

  Impact:
  Successful exploitation could result in application crash.

  Impact Level: Application

  Affected Software/OS:
  Incredimail 5.8.5.3710 (5853710) and prior on Windows.

  Fix: Upgrade to latest version of Incredimail-5.8.5.3849 (5853849)
  http://www.incredimail.com/english/download/

  References:
  http://www.securityfocus.com/archive/1/499038
  http://www.securityfocus.com/archive/1/499045
  http://mime.recurity.com/cgi-bin/twiki/view/Main/AttackIntro

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Incredimail");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!(get_kb_item("SMB/WindowsVersion"))){
  exit(0);
}

mailVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\IncrediMail", item:"DisplayVersion");
if(!mailVer){
  exit(0);
}

mailVer = eregmatch(pattern:"([0-9.]+)", string:mailVer);
if(mailVer[1] != NULL)
{
  if(version_is_less_equal(version:mailVer[1], test_version:"5.8.5.3710")){
    security_warning(0);
  }
}
