###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for ftp HPSBUX02334
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835177);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02334");
  script_cve_id("CVE-2008-0713");
  script_name(english: "HP-UX Update for ftp HPSBUX02334");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  ftp. The vulnerability could be exploited remotely to create a Denial of 
  Service (DoS). The Denial of Service (DoS) affects the ftp server 
  application only. 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  ftp on
  HP-UX B.11.11, B.11.23, B.11.31 running ftp. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01446326-4

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ftp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"FTP.FTP-AUX", revision:"C.2.6.1.3.0", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"FTP.FTP-RUN", revision:"C.2.6.1.3.0", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS2-RUN", patch_list:['PHNE_36193'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_36192'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"WUFTP-26.INETSVCS-FTP", revision:"B.11.11.01.011", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}