###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for ptrace(2) HPSBUX00206
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835060);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00206");
  script_cve_id("");
  script_name(english: "HP-UX Update for ptrace(2) HPSBUX00206");
  desc["english"] = "

  Vulnerability Insight:
  A vulnerability in the ptrace(2) may allow local users to create a denial of 
  service (DoS). 

  Impact:
  Local denial of service (DoS)

  Affected Software/OS:
  ptrace(2) on
  HP-UX release B.11.00, B.11.04, and B.11.11. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01035655-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ptrace(2)");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHKL_27180'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHKL_27536'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHKL_27179'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}