###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_graphicsmagick_mult_vuln_lin.nasl 1015 2009-02-16 15:12:39Z feb $
#
# GraphicsMagick Multiple Vulnerabilities (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800517);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-6070", "CVE-2008-6071", "CVE-2008-6072", "CVE-2008-6621");
  script_bugtraq_id(29583);
  script_name(english:"GraphicsMagick Multiple Vulnerabilities (Linux)");
  desc["english"] = "

  Overview: This host is running GraphicsMagick graphics tool and is prone
  to multiple buffer overflow/underflow vulnerabilities.

  Vulnerability Insight:
  Multiple flaws due to,
  - two boundary errors within the ReadPALMImage function in coders/palm.c,
  - a boundary error within the DecodeImage function in coders/pict.a,
  - unknown errors within the processing of XCF, DPX, and CINEON images.
  - error exists while processing malformed data in DPX which causes input
    validation vulnerability.

  Impact:
  A remote user could execute arbitrary code on the target system and can
  cause denial-of-service or compromise a vulnerable system via specially
  crafted PALM, PICT, XCF, DPX and CINEON images.

  Impact level: System/Application

  Affected Software/OS:
  GraphicsMagick version prior to 1.1.14 and 1.2.3 on Linux.

  Fix: Update to version 1.1.14 or 1.2.3,
  http://sourceforge.net/projects/graphicsmagick

  References:
  http://secunia.com/advisories/30549
  http://www.vupen.com/english/advisories/2008/1767
  http://sourceforge.net/project/shownotes.php?release_id=604837
  http://cvs.graphicsmagick.org/cgi-bin/cvsweb.cgi/GraphicsMagick/coders/dpx.c
  http://cvs.graphicsmagick.org/cgi-bin/cvsweb.cgi/GraphicsMagick/coders/xcf.c
  http://cvs.graphicsmagick.org/cgi-bin/cvsweb.cgi/GraphicsMagick/coders/pict.c
  http://cvs.graphicsmagick.org/cgi-bin/cvsweb.cgi/GraphicsMagick/coders/cineon.c

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of GraphicsMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_graphicsmagick_detect_lin.nasl");
  script_require_keys("GraphicsMagick/Linux/Ver");
  exit(0);
}


include("version_func.inc");

gmVer = get_kb_item("GraphicsMagick/Linux/Ver");
if(gmVer == NULL){
  exit(0);
}

# Check for version 1.0 to 1.1.13 and 1.2 to 1.2.2
if(version_in_range(version:gmVer, test_version:"1.0", test_version2:"1.1.13") ||
   version_in_range(version:gmVer, test_version:"1.2", test_version2:"1.2.2")){
  security_hole(0);
}
