###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_mem_leak_dos_vuln_lin.nasl 811 2009-01-08 12:29:54Z jan $
#
# Firefox Browser Libxul Memory Leak Remote DoS Vulnerability - Linux
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800402);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5822");
  script_name(english:"Firefox Browser Libxul Memory Leak Remote DoS Vulnerability - Linux");
  desc["english"] = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  The Browser fails to validate the user input data in Libxul, which leads
  to memory consumption or crash.

  Impact: Successful exploitation could result in denying the service.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.0.2 to 3.0.5 on Linux.

  Fix: No solution or patch is available as on 09th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://liudieyu0.blog124.fc2.com/blog-entry-6.html
  http://www.packetstormsecurity.org/0812-exploits/mzff_libxul_ml.txt
  http://www.securityfocus.com/archive/1/archive/1/497091/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for firefox version 3.0.2 to 3.0.5
if(version_in_range(version:ffVer, test_version:"3.0.2",
                                  test_version2:"3.0.5")){
  security_warning(0);
}
