###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for pam_krb5 FEDORA-2008-8605
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860732);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-8605");
  script_cve_id("CVE-2008-3825");
  script_name(english: "Fedora Update for pam_krb5 FEDORA-2008-8605");
  desc["english"] = "

  Vulnerability Insight:
  This is pam_krb5, a pluggable authentication module that can be used with
  Linux-PAM and Kerberos 5. This module supports password checking, ticket
  creation, and optional TGT verification and conversion to Kerberos IV tickets.
  The included pam_krb5afs module also gets AFS tokens if so configured.


  Affected Software/OS:
  pam_krb5 on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00150.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pam_krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"pam_krb5", rpm:"pam_krb5~2.2.18~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}