###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ssmtp FEDORA-2008-8040
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860068);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-8040");
  script_cve_id("CVE-2008-3962");
  script_name(english: "Fedora Update for ssmtp FEDORA-2008-8040");
  desc["english"] = "

  Vulnerability Insight:
  A secure, effective and simple way of getting mail off a system to your mail
  hub. It contains no suid-binaries or other dangerous things - no mail spool
  to poke around in, and no daemons running in the background. Mail is simply
  forwarded to the configured mailhost. Extremely easy configuration.
  
  WARNING: the above is all it does; it does not receive mail, expand aliases
  or manage a queue. That belongs on a mail hub with a system administrator.


  Affected Software/OS:
  ssmtp on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-September/msg00757.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ssmtp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"ssmtp", rpm:"ssmtp~2.61~11.6.fc8.1", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}