###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for wireshark FEDORA-2008-2941
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860983);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-2941");
  script_cve_id("CVE-2008-1072", "CVE-2008-1563", "CVE-2008-1070", "CVE-2008-1561", "CVE-2008-1562", "CVE-2008-1071");
  script_name(english: "Fedora Update for wireshark FEDORA-2008-2941");
  desc["english"] = "

  Vulnerability Insight:
  Wireshark is a network traffic analyzer for Unix-ish operating systems.
  
  This package lays base for libpcap, a packet capture and filtering
  library, contains command-line utilities, contains plugins and
  documentation for wireshark. A graphical user interface is packaged
  separately to GTK+ package.


  Affected Software/OS:
  wireshark on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00140.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}