###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for clamav FEDORA-2008-1625
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860168);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-1625");
  script_cve_id("CVE-2008-0318", "CVE-2007-6335");
  script_name(english: "Fedora Update for clamav FEDORA-2008-1625");
  desc["english"] = "

  Vulnerability Insight:
  Clam AntiVirus is an anti-virus toolkit for UNIX. The main purpose of this
  software is the integration with mail servers (attachment scanning). The
  package provides a flexible and scalable multi-threaded daemon, a command
  line scanner, and a tool for automatic updating via Internet. The programs
  are based on a shared library distributed with the Clam AntiVirus package,
  which you can use with your own software. The virus database is based on
  the virus database from OpenAntiVirus, but contains additional signatures
  (including signatures for popular polymorphic viruses, too) and is KEPT UP
  TO DATE.


  Affected Software/OS:
  clamav on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-February/msg00481.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of clamav");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.92.1~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}