###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for perl-Tk FEDORA-2008-1384
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860741);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-1384");
  script_cve_id("CVE-2008-0553");
  script_name(english: "Fedora Update for perl-Tk FEDORA-2008-1384");
  desc["english"] = "

  Vulnerability Insight:
  This a re-port of a perl interface to Tk8.4.
  C code is derived from Tcl/Tk8.4.5.
  It also includes all the C code parts of Tix8.1.4 from SourceForge.
  The perl code corresponding to Tix's Tcl code is not fully implemented.
  
  Perl API is essentially the same as Tk800 series Tk800.025 but has not
  been verified as compliant. There ARE differences see pod/804delta.pod.


  Affected Software/OS:
  perl-Tk on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-February/msg00205.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of perl-Tk");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"perl-Tk", rpm:"perl-Tk~804.028~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}