###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for synce-serial FEDORA-2008-0680
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860242);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-0680");
  script_cve_id("CVE-2007-6703", "CVE-2008-1136");
  script_name(english: "Fedora Update for synce-serial FEDORA-2008-0680");
  desc["english"] = "

  Vulnerability Insight:
  Synce-serial is part of the SynCE project: <a  rel= &qt nofollow &qt  href= &qt http://www.synce.org &qt >http://www.synce.org</a>
  
  This module contains helper scripts for setting up a serial connection for use
  with SynCE. They are basically wrappers around pppd:
    synce-serial-config  - Use this to select serial port and IP addresses
    synce-serial-start   - Use this to start connection
    synce-serial-abort   - Use this to abort a connection
  
  Please read the included README.Fedora for details


  Affected Software/OS:
  synce-serial on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-March/msg00134.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of synce-serial");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"synce-serial", rpm:"synce-serial~0.11~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}