###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ruby FEDORA-2007-738
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861063);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-738");
  script_cve_id("CVE-2007-5162");
  script_name(english: "Fedora Update for ruby FEDORA-2007-738");
  desc["english"] = "

  Vulnerability Insight:
  Ruby is the interpreted scripting language for quick and easy
  object-oriented programming.  It has many features to process text
  files and to do system management tasks (as in Perl).  It is simple,
  straight-forward, and extensible.


  Affected Software/OS:
  ruby on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00076.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-docs", rpm:"x86_64/ruby-docs~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-rdoc", rpm:"x86_64/ruby-rdoc~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-irb", rpm:"x86_64/ruby-irb~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby", rpm:"x86_64/ruby~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-tcltk", rpm:"x86_64/ruby-tcltk~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-mode", rpm:"x86_64/ruby-mode~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/ruby-debuginfo", rpm:"x86_64/debug/ruby-debuginfo~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-ri", rpm:"x86_64/ruby-ri~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-devel", rpm:"x86_64/ruby-devel~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ruby-libs", rpm:"x86_64/ruby-libs~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-rdoc", rpm:"i386/ruby-rdoc~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/ruby-debuginfo", rpm:"i386/debug/ruby-debuginfo~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-ri", rpm:"i386/ruby-ri~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-docs", rpm:"i386/ruby-docs~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby", rpm:"i386/ruby~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-tcltk", rpm:"i386/ruby-tcltk~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-libs", rpm:"i386/ruby-libs~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-mode", rpm:"i386/ruby-mode~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-devel", rpm:"i386/ruby-devel~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ruby-irb", rpm:"i386/ruby-irb~1.8.5.114~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}