###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bpftp_client_bof_vuln.nasl 797 2009-01-02 20:10:24Z jan $
#
# BulletProof FTP Client '.bps' File Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800330);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5753", "CVE-2008-5754");
  script_bugtraq_id(33007, 33024);
  script_name(english:"BulletProof FTP Client '.bps' File Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host has BulletProof FTP Client installed and is prone to
  Stack-Based Buffer Overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper boundary checks in .bps file with a long
  second line and bookmark file entry with a long host name.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary codes in
  the context of the application and can cause Denial of Service to the
  application.

  Impact Level: Application

  Affected Software/OS:
  BulletProof FTP Client version 2.63.0.56 or prior on Windows

  Fix: No solution or patch is available as on 5th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.bpftp.com/

  References:
  http://secunia.com/advisories/33322
  http://www.milw0rm.com/exploits/7571
  http://www.milw0rm.com/exploits/7589

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of BulletProof FTP Client");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_bpftp_detect.nasl");
  exit(0);
}


include("version_func.inc");

ver = get_kb_item("BulletProof/Client/Ver");
if(!ver){
  exit(0);
}

# Grep for version 2.63.0.56 or prior
if(version_is_less_equal(version:ver, test_version:"2.63.0.56")){
  security_hole(0);
}
