###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_detect_lin.nasl 320 2008-10-21 09:42:59Z oct $
#
# Adobe Flash Player Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800032);
  script_version("$Revision: 1.0 $");
  script_name(english:"Adobe Flash Player Version Detection (Linux)");
  desc["english"] = "
  Overview: This script detects the version of Adobe Product(s) and sets the
  result in the KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

grep = find_bin(prog_name:"grep", sock:sock);
grep = chomp(grep[0]);

garg[0] = "-o";
garg[1] = "-m1";
garg[2] = "-a";
garg[3] = string("[0-9]\\+,[0-9]\\+,[0-9]\\+,[0-9]\\+");

# Set KB for Adobe Flash Player
flashName = find_file(file_name:"libflashplayer.so", file_path:"/",
                      useregex:TRUE, regexpar:"$", sock:sock);
if(flashName != NULL)
{
  foreach binaryName (flashName)
  {
    binaryName = chomp(binaryName);
    if(islocalhost())
    {
      garg[4] = binaryName;
      arg = garg;
    }
    else
    {
      arg = garg[0]+" "+garg[1]+" "+garg[2]+" "+
            raw_string(0x22)+garg[3]+raw_string(0x22)+" "+binaryName;
    }

    flashVer = get_bin_version(full_prog_name:grep, version_argv:arg, sock:sock,
                               ver_pattern:"([0-9]+,[0-9]+,[0-9]+,[0-9]+)");
    if(flashVer[0] != NULL)
    {
      set_kb_item(name:"AdobeFlashPlayer/Linux/Ver", value:flashVer[0]);
      break;
    }
  }
}

# Set KB for Adobe AIR
path = "/opt/Adobe\ AIR/Versions/1.0/Resources/ApolloVersion";
if(path != NULL)
{
  airVer = get_bin_version(full_prog_name:"cat", version_argv:path,
                           ver_pattern:"", sock:sock);
  if(airVer[1] != NULL){
    set_kb_item(name:"Adobe/Air/Linux/Ver", value:airVer[1]);
  }
}
ssh_close_connection();
