###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_aceftp_remote_dir_traversal_vuln.nasl 509 2008-12-01 13:15:24Z oct $
#
# AceFTP LIST Command Directory Traversal Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800307);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5175");
  script_bugtraq_id(29989);
  script_name(english:"AceFTP LIST Command Directory Traversal Vulnerability");
  desc["english"] = "

  Overview: The host is installed with AceFTP and is prone to Directory
  Traversal Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to input validation errors when processing FTP
  responses to a LIST command. These can be exploited by attackers when
  downloading the directories containing files with directory traversal
  specifiers in the filename.

  Impact:
  Successful exploitation allows attackers to execute arbitrary code by
  tricking a user into downloading a directory containing files with
  specially crafted filenames from a malicious FTP server.

  Impact Level: Application

  Affected Software/OS:
  Visicom Media’s AceFTP Freeware/Pro Version 3.80.3 and prior on W
  Windows

  Fix: No solution/patch is available as on 1st December, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://software.visicommedia.com/en/products/

  References:
  http://vuln.sg/aceftp3803-en.html
  http://secunia.com/advisories/30792
  http://www.frsirt.com/english/advisories/2008/1954

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of AceFTP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

keys = registry_enum_keys(key:key);
foreach item (keys)
{
  aceName = registry_get_sz(item:"DisplayName", key:key + item);

  if("AceFTP 3 Freeware" >< aceName || "AceFTP 3 Pro" >< aceName)
  {
    aceVer = registry_get_sz(item:"DisplayVersion", key:key + item);
    if(!aceVer){
      exit(0);
    }

    if(version_is_less_equal(version:aceVer, test_version:"3.80.3")){
      security_hole(0);
      exit(0);
    }
  }
}
