###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for firefox RHSA-2008:1036-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870116);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:1036-01");
  script_cve_id("CVE-2008-5500", "CVE-2008-5501", "CVE-2008-5502", "CVE-2008-5505", "CVE-2008-5506", "CVE-2008-5507", "CVE-2008-5508", "CVE-2008-5510", "CVE-2008-5511", "CVE-2008-5512", "CVE-2008-5513");
  script_name(english: "RedHat Update for firefox RHSA-2008:1036-01");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Firefox is an open source Web browser.
  
  Several flaws were found in the processing of malformed web content. A web
  page containing malicious content could cause Firefox to crash or,
  potentially, execute arbitrary code as the user running Firefox.
  (CVE-2008-5500, CVE-2008-5501, CVE-2008-5502, CVE-2008-5511, CVE-2008-5512,
  CVE-2008-5513)
  
  Several flaws were found in the way malformed content was processed. A
  website containing specially-crafted content could potentially trick a
  Firefox user into surrendering sensitive information. (CVE-2008-5506,
  CVE-2008-5507)
  
  A flaw was found in the way Firefox stored attributes in XML User Interface
  Language (XUL) elements. A web site could use this flaw to track users
  across browser sessions, even if users did not allow the site to store
  cookies in the victim's browser. (CVE-2008-5505)
  
  A flaw was found in the way malformed URLs were processed by Firefox.
  This flaw could prevent various URL sanitization mechanisms from properly
  parsing a malicious URL. (CVE-2008-5508)
  
  A flaw was found in Firefox's CSS parser. A malicious web page could inject
  NULL characters into a CSS input string, possibly bypassing an
  application's script sanitization routines. (CVE-2008-5510)
  
  For technical details regarding these flaws, please see the Mozilla
  security advisories for Firefox 3.0.5. You can find a link to the Mozilla
  advisories in the References section.
  
  Note: after the errata packages are installed, Firefox must be restarted
  for the update to take effect.
  
  All firefox users should upgrade to these updated packages, which contain
  backported patches that correct these issues.


  Affected Software/OS:
  firefox on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-December/msg00011.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.5~1.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.5~1.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nspr", rpm:"nspr~4.7.3~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nspr-debuginfo", rpm:"nspr-debuginfo~4.7.3~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nspr-devel", rpm:"nspr-devel~4.7.3~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.2.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.2.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.2.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-pkcs11-devel", rpm:"nss-pkcs11-devel~3.12.2.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-tools", rpm:"nss-tools~3.12.2.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9.0.5~1.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9.0.5~1.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9.0.5~1.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9.0.5~1.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.5~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.5~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nspr", rpm:"nspr~4.7.3~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nspr-debuginfo", rpm:"nspr-debuginfo~4.7.3~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nspr-devel", rpm:"nspr-devel~4.7.3~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss", rpm:"nss~3.12.2.0~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-debuginfo", rpm:"nss-debuginfo~3.12.2.0~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss-devel", rpm:"nss-devel~3.12.2.0~1.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}