###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:1017-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870063);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:1017-01");
  script_cve_id("CVE-2008-3831", "CVE-2008-4554", "CVE-2008-4576");
  script_name(english: "RedHat Update for kernel RHSA-2008:1017-01");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  * Olaf Kirch reported a flaw in the i915 kernel driver that only affects
  the Intel G33 series and newer. This flaw could, potentially, lead to local
  privilege escalation. (CVE-2008-3831, Important)
  
  * Miklos Szeredi reported a missing check for files opened with O_APPEND in
  the sys_splice(). This could allow a local, unprivileged user to bypass the
  append-only file restrictions. (CVE-2008-4554, Important)
   
  * a deficiency was found in the Linux kernel Stream Control Transmission
  Protocol (SCTP) implementation. This could lead to a possible denial of
  service if one end of a SCTP connection did not support the AUTH extension.
  (CVE-2008-4576, Important)
  
  In addition, these updated packages fix the following bugs:
  
  * on Itanium® systems, when a multithreaded program was traced using the
  command &quot;strace -f&quot;, messages similar to the following ones were displayed,
  after which the trace would stop:
  
  	PANIC: attached pid 10740 exited
  	PANIC: handle_group_exit: 10740 leader 10721
  	PANIC: attached pid 10739 exited
  	PANIC: handle_group_exit: 10739 leader 10721
  	...
  
  In these updated packages, tracing a multithreaded program using the
  &quot;strace -f&quot; command no longer results in these error messages, and strace
  terminates normally after tracing all threads.
  
  * on big-endian systems such as PowerPC, the getsockopt() function
  incorrectly returned 0 depending on the parameters passed to it when the
  time to live (TTL) value equaled 255.
  
  * when using an NFSv4 file system, accessing the same file with two
  separate processes simultaneously resulted in the NFS client process
  becoming unresponsive.
  
  * on AMD64 and Intel® 64 hypervisor-enabled systems, in cases in which a
  syscall correctly returned '-1' in code compiled on Red Hat Enterprise
  Linux 5, the same code, when run with the strace utility, would incorrectly
  return an invalid return value. This has been fixed so that on AMD64 and
  Intel® 64 hypervisor-enabled systems, syscalls in compiled code return the
  same, correct values as syscalls do when run with strace.
  
  * on the Itanium® architecture, fully-virtualized guest domains which were
  created using more than 64 GB of memory caused other guest domains not to
  receive interrupts, which caused a soft lockup on other guests. All guest
  domains are now able to receive interrupts regardless of their allotted memory.
  
  * when user-space used SIGIO notification, which wasn't disabled ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-December/msg00010.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~92.1.22.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}