###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for tog-pegasus RHSA-2008:1001-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870015);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:1001-01");
  script_cve_id("CVE-2008-4313", "CVE-2008-4315");
  script_name(english: "RedHat Update for tog-pegasus RHSA-2008:1001-01");
  desc["english"] = "

  Vulnerability Insight:
  The tog-pegasus packages provide OpenPegasus Web-Based Enterprise
  Management (WBEM) services. WBEM is a platform and resource independent
  Distributed Management Task Force (DMTF) standard that defines a common
  information model and communication protocol for monitoring and controlling
  resources.
  
  Red Hat defines additional security enhancements for OpenGroup Pegasus WBEM
  services in addition to those defined by the upstream OpenGroup Pegasus
  release. For details regarding these enhancements, refer to the file
  &quot;README.RedHat.Security&quot;, included in the Red Hat tog-pegasus package.
  
  After re-basing to version 2.7.0 of the OpenGroup Pegasus code, these
  additional security enhancements were no longer being applied. As a
  consequence, access to OpenPegasus WBEM services was not restricted to the
  dedicated users as described in README.RedHat.Security. An attacker able to
  authenticate using a valid user account could use this flaw to send
  requests to WBEM services. (CVE-2008-4313)
  
  Note: default SELinux policy prevents tog-pegasus from modifying system
  files. This flaw's impact depends on whether or not tog-pegasus is confined
  by SELinux, and on any additional CMPI providers installed and enabled on a
  particular system.
  
  Failed authentication attempts against the OpenPegasus CIM server were not
  logged to the system log as documented in README.RedHat.Security. An
  attacker could use this flaw to perform password guessing attacks against a
  user account without leaving traces in the system log. (CVE-2008-4315)
  
  All tog-pegasus users are advised to upgrade to these updated packages,
  which contain patches to correct these issues.


  Affected Software/OS:
  tog-pegasus on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-November/msg00016.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of tog-pegasus");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"tog-pegasus", rpm:"tog-pegasus~2.7.0~2.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-debuginfo", rpm:"tog-pegasus-debuginfo~2.7.0~2.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tog-pegasus-devel", rpm:"tog-pegasus-devel~2.7.0~2.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}