###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0973-03
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870022);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0973-03");
  script_cve_id("CVE-2008-4210", "CVE-2008-3275", "CVE-2008-0598", "CVE-2008-2136", "CVE-2008-2812", "CVE-2007-6063", "CVE-2008-3525");
  script_name(english: "RedHat Update for kernel RHSA-2008:0973-03");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  This update addresses the following security issues:
  
  * Tavis Ormandy discovered a deficiency in the Linux kernel 32-bit and
  64-bit emulation. This could allow a local, unprivileged user to prepare
  and run a specially-crafted binary which would use this deficiency to leak
  uninitialized and potentially sensitive data. (CVE-2008-0598, Important)
  
  * a possible kernel memory leak was found in the Linux kernel Simple
  Internet Transition (SIT) INET6 implementation. This could allow a local,
  unprivileged user to cause a denial of service. (CVE-2008-2136, Important)
  
  * missing capability checks were found in the SBNI WAN driver which could
  allow a local user to bypass intended capability restrictions.
  (CVE-2008-3525, Important)
  
  * the do_truncate() and generic_file_splice_write() functions did not clear
  the setuid and setgid bits. This could allow a local, unprivileged user to
  obtain access to privileged information. (CVE-2008-4210, Important)
  
  * a buffer overflow flaw was found in Integrated Services Digital Network
  (ISDN) subsystem. A local, unprivileged user could use this flaw to cause a
  denial of service. (CVE-2007-6063, Moderate)
  
  * multiple NULL pointer dereferences were found in various Linux kernel
  network drivers. These drivers were missing checks for terminal validity,
  which could allow privilege escalation. (CVE-2008-2812, Moderate)
  
  * a deficiency was found in the Linux kernel virtual filesystem (VFS)
  implementation. This could allow a local, unprivileged user to attempt file
  creation within deleted directories, possibly causing a denial of service.
  (CVE-2008-3275, Moderate)
  
  This update also fixes the following bugs:
  
  * the incorrect kunmap function was used in nfs_xdr_readlinkres. kunmap()
  was used where kunmap_atomic() should have been. As a consequence, if an
  NFSv2 or NFSv3 server exported a volume containing a symlink which included
  a path equal to or longer than the local system's PATH_MAX, accessing the
  link caused a kernel oops. This has been corrected in this update.
  
  * mptctl_gettargetinfo did not check if pIoc3 was NULL before using it as a
  pointer. This caused a kernel panic in mptctl_gettargetinfo in some
  circumstances. A check has been added which prevents this.
  
  * lost tick compensation code in the timer interrupt routine triggered
  without apparent cause. When running as a fully-virtuali ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-December/msg00013.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-BOOT", rpm:"kernel-BOOT~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem-unsupported", rpm:"kernel-hugemem-unsupported~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp-unsupported", rpm:"kernel-smp-unsupported~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-unsupported", rpm:"kernel-unsupported~2.4.21~58.EL", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}