###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0957-02
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870061);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0957-02");
  script_cve_id("CVE-2006-5755", "CVE-2007-5907", "CVE-2008-2372", "CVE-2008-3276", "CVE-2008-3527", "CVE-2008-3833", "CVE-2008-4210", "CVE-2008-4302");
  script_name(english: "RedHat Update for kernel RHSA-2008:0957-02");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  * the Xen implementation did not prevent applications running in a
  para-virtualized guest from modifying CR4 TSC. This could cause a local
  denial of service. (CVE-2007-5907, Important)
  
  * Tavis Ormandy reported missing boundary checks in the Virtual Dynamic
  Shared Objects (vDSO) implementation. This could allow a local unprivileged
  user to cause a denial of service or escalate privileges. (CVE-2008-3527,
  Important)
  
  * the do_truncate() and generic_file_splice_write() functions did not clear
  the setuid and setgid bits. This could allow a local unprivileged user to
  obtain access to privileged information. (CVE-2008-4210, CVE-2008-3833,
  Important)
  
  * a flaw was found in the Linux kernel splice implementation. This could
  cause a local denial of service when there is a certain failure in the
  add_to_page_cache_lru() function. (CVE-2008-4302, Important)
  
  * a flaw was found in the Linux kernel when running on AMD64 systems.
  During a context switch, EFLAGS were being neither saved nor restored. This
  could allow a local unprivileged user to cause a denial of service.
  (CVE-2006-5755, Low)
  
  * a flaw was found in the Linux kernel virtual memory implementation. This
  could allow a local unprivileged user to cause a denial of service.
  (CVE-2008-2372, Low)
  
  * an integer overflow was discovered in the Linux kernel Datagram
  Congestion Control Protocol (DCCP) implementation. This could allow a
  remote attacker to cause a denial of service. By default, remote DCCP is
  blocked by SELinux. (CVE-2008-3276, Low)
  
  In addition, these updated packages fix the following bugs:
  
  * random32() seeding has been improved. 
  
  * in a multi-core environment, a race between the QP async event-handler
  and the destro_qp() function could occur. This led to unpredictable results
  during invalid memory access, which could lead to a kernel crash.
  
  * a format string was omitted in the call to the request_module() function.
  
  * a stack overflow caused by an infinite recursion bug in the binfmt_misc
  kernel module was corrected.
  
  * the ata_scsi_rbuf_get() and ata_scsi_rbuf_put() functions now check for
  scatterlist usage before calling kmap_atomic().
  
  * a sentinel NUL byte was added to the device_write() function to ensure
  that lspace.name is NUL-terminated.
  
  * in the character device driver, a range_is_allowed() check was added to
  the read_mem() and write_mem() functions. It was possible for an
  illegitimate application to b ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-November/msg00001.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~92.1.17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}