###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for ed RHSA-2008:0946-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870096);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0946-01");
  script_cve_id("CVE-2008-3916");
  script_name(english: "RedHat Update for ed RHSA-2008:0946-01");
  desc["english"] = "

  Vulnerability Insight:
  ed is a line-oriented text editor, used to create, display, and modify
  text files (both interactively and via shell scripts).
  
  A heap-based buffer overflow was discovered in the way ed, the GNU line
  editor, processed long file names. An attacker could create a file with a
  specially-crafted name that could possibly execute an arbitrary code when
  opened in the ed editor. (CVE-2008-3916)
  
  Users of ed should upgrade to this updated package, which contains
  a backported patch to resolve this issue.


  Affected Software/OS:
  ed on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-October/msg00013.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ed");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"ed", rpm:"ed~0.2~21.1", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"ed", rpm:"ed~0.2~39.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ed-debuginfo", rpm:"ed-debuginfo~0.2~39.el5_2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"ed", rpm:"ed~0.2~36.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ed-debuginfo", rpm:"ed-debuginfo~0.2~36.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"ed", rpm:"ed~0.2~33.30E.1", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ed-debuginfo", rpm:"ed-debuginfo~0.2~33.30E.1", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}