###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for ruby RHSA-2008:0897-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870035);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0897-01");
  script_cve_id("CVE-2008-3443", "CVE-2008-3655", "CVE-2008-3656", "CVE-2008-3657", "CVE-2008-3790", "CVE-2008-3905");
  script_name(english: "RedHat Update for ruby RHSA-2008:0897-01");
  desc["english"] = "

  Vulnerability Insight:
  Ruby is an interpreted scripting language for quick and easy
  object-oriented programming.
  
  The Ruby DNS resolver library, resolv.rb, used predictable transaction IDs
  and a fixed source port when sending DNS requests. A remote attacker could
  use this flaw to spoof a malicious reply to a DNS query. (CVE-2008-3905)
  
  Ruby's XML document parsing module (REXML) was prone to a denial of service
  attack via XML documents with large XML entity definitions recursion. A
  specially-crafted XML file could cause a Ruby application using the REXML
  module to use an excessive amount of CPU and memory. (CVE-2008-3790)
  
  An insufficient &quot;taintness&quot; check flaw was discovered in Ruby's DL module,
  which provides direct access to the C language functions. An attacker could
  use this flaw to bypass intended safe-level restrictions by calling
  external C functions with the arguments from an untrusted tainted inputs.
  (CVE-2008-3657)
  
  A denial of service flaw was discovered in WEBrick, Ruby's HTTP server
  toolkit. A remote attacker could send a specially-crafted HTTP request to a
  WEBrick server that would cause the server to use an excessive amount of
  CPU time. (CVE-2008-3656)
  
  A number of flaws were found in the safe-level restrictions in Ruby. It
  was possible for an attacker to create a carefully crafted malicious script
  that can allow the bypass of certain safe-level restrictions. (CVE-2008-3655)
  
  A denial of service flaw was found in Ruby's regular expression engine. If
  a Ruby script tried to process a large amount of data via a regular
  expression, it could cause Ruby to enter an infinite-loop and crash.
  (CVE-2008-3443)
  
  Users of ruby should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  ruby on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-October/msg00012.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-debuginfo", rpm:"ruby-debuginfo~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-docs", rpm:"ruby-docs~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-irb", rpm:"ruby-irb~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libs", rpm:"ruby-libs~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-mode", rpm:"ruby-mode~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-rdoc", rpm:"ruby-rdoc~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-ri", rpm:"ruby-ri~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tcltk", rpm:"ruby-tcltk~1.8.5~5.el5_2.5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"irb", rpm:"irb~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-debuginfo", rpm:"ruby-debuginfo~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-docs", rpm:"ruby-docs~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libs", rpm:"ruby-libs~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-mode", rpm:"ruby-mode~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tcltk", rpm:"ruby-tcltk~1.8.1~7.el4_7.1", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}