###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0233-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870164);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0233-01");
  script_cve_id("CVE-2007-5498", "CVE-2008-0007", "CVE-2008-1367", "CVE-2008-1375", "CVE-2008-1619", "CVE-2008-1669");
  script_name(english: "RedHat Update for kernel RHSA-2008:0233-01");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  These updated packages fix the following security issues:
  
  * the absence of a protection mechanism when attempting to access a
  critical section of code has been found in the Linux kernel open file
  descriptors control mechanism, fcntl. This could allow a local unprivileged
  user to simultaneously execute code, which would otherwise be protected
  against parallel execution. As well, a race condition when handling locks
  in the Linux kernel fcntl functionality, may have allowed a process
  belonging to a local unprivileged user to gain re-ordered access to the
  descriptor table. (CVE-2008-1669, Important)
  
  * a possible hypervisor panic was found in the Linux kernel. A privileged
  user of a fully virtualized guest could initiate a stress-test File
  Transfer Protocol (FTP) transfer between the guest and the hypervisor,
  possibly leading to hypervisor panic. (CVE-2008-1619, Important)
  
  * the absence of a protection mechanism when attempting to access a
  critical section of code, as well as a race condition, have been found
  in the Linux kernel file system event notifier, dnotify. This could allow a
  local unprivileged user to get inconsistent data, or to send arbitrary
  signals to arbitrary system processes. (CVE-2008-1375, Important)
  
  Red Hat would like to thank Nick Piggin for responsibly disclosing the
  following issue:
  
  * when accessing kernel memory locations, certain Linux kernel drivers
  registering a fault handler did not perform required range checks. A local
  unprivileged user could use this flaw to gain read or write access to
  arbitrary kernel memory, or possibly cause a kernel crash.
  (CVE-2008-0007, Important)
  
  * the absence of sanity-checks was found in the hypervisor block backend
  driver, when running 32-bit paravirtualized guests on a 64-bit host. The
  number of blocks to be processed per one request from guest to host, or
  vice-versa, was not checked for its maximum value, which could have allowed
  a local privileged user of the guest operating system to cause a denial of
  service. (CVE-2007-5498, Important)
  
  * it was discovered that the Linux kernel handled string operations in the
  opposite way to the GNU Compiler Collection (GCC). This could allow a local
  unprivileged user to cause memory corruption. (CVE-2008-1367, Low)
  
  As well, these updated packages fix the following bugs:
  
  * on IBM System z architectures, when running QIOASSIST enabled QDIO
  devices in an IBM z/VM environment, the output qu ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00001.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~53.1.19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}