###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0154-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870067);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0154-01");
  script_cve_id("CVE-2006-6921", "CVE-2007-5938", "CVE-2007-6063", "CVE-2007-6207", "CVE-2007-6694");
  script_name(english: "RedHat Update for kernel RHSA-2008:0154-01");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  These updated packages fix the following security issues:
  
  * a flaw in the hypervisor for hosts running on Itanium architectures
  allowed an Intel VTi domain to read arbitrary physical memory from other
  Intel VTi domains, which could make information available to unauthorized
  users. (CVE-2007-6207, Important)
  
  * two buffer overflow flaws were found in ISDN subsystem. A local
  unprivileged user could use these flaws to cause a denial of service.
  (CVE-2007-5938: Important, CVE-2007-6063: Moderate)
  
  * a possible NULL pointer dereference was found in the subsystem used for
  showing CPU information, as used by CHRP systems on PowerPC architectures.
  This may have allowed a local unprivileged user to cause a denial of
  service (crash). (CVE-2007-6694, Moderate)
  
  * a flaw was found in the handling of zombie processes. A local user could
  create processes that would not be properly reaped, possibly causing a
  denial of service. (CVE-2006-6921, Moderate)
  
  As well, these updated packages fix the following bugs:
  
  * a bug was found in the Linux kernel audit subsystem. When the audit
  daemon was setup to log the execve system call with a large number of
  arguments, the kernel could run out of memory, causing a kernel panic.
  
  * on IBM System z architectures, using the IBM Hardware Management Console
  to toggle IBM FICON channel path ids (CHPID) caused a file ID miscompare,
  possibly causing data corruption.
  
  * when running the IA-32 Execution Layer (IA-32EL) or a Java VM on Itanium
  architectures, a bug in the address translation in the hypervisor caused
  the wrong address to be registered, causing Dom0 to hang.
  
  * on Itanium architectures, frequent Corrected Platform Error errors may
  have caused the hypervisor to hang.
  
  * when enabling a CPU without hot plug support, routines for checking the
  presence of the CPU were missing. The CPU tried to access its own
  resources, causing a kernel panic.
  
  * after updating to kernel-2.6.18-53.el5, a bug in the CCISS driver caused
  the HP Array Configuration Utility CLI to become unstable, possibly causing
  a system hang, or a kernel panic.
  
  * a bug in NFS directory caching could have caused different hosts to have
  different views of NFS directories.
  
  * on Itanium architectures, the Corrected Machine Check Interrupt masked
  hot-added CPUs as disabled.
  
  * when running Oracle database software on the Intel 64 and AMD64
  architectures, if an SGA larger than 4GB was crea ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  kernel on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-March/msg00003.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~53.1.14.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}