###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for postfix CESA-2008:0839 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880268);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0839");
  script_cve_id("CVE-2008-2936");
  script_name(english: "CentOS Update for postfix CESA-2008:0839 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  Postfix is a Mail Transport Agent (MTA), supporting LDAP, SMTP AUTH (SASL),
  and TLS.
  
  A flaw was found in the way Postfix dereferences symbolic links. If a local
  user has write access to a mail spool directory with no root mailbox, it
  may be possible for them to append arbitrary data to files that root has
  write permission to. (CVE-2008-2936)
  
  Red Hat would like to thank Sebastian Krahmer for responsibly disclosing
  this issue.
  
  All users of postfix should upgrade to these updated packages, which
  contain a backported patch that resolves this issue.


  Affected Software/OS:
  postfix on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-August/015185.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postfix");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.0.16~14.1.RHEL3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}