###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for firefox CESA-2008:0103 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880191);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0103");
  script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593");
  script_name(english: "CentOS Update for firefox CESA-2008:0103 centos4 i386");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Firefox is an open source Web browser.
  
  Several flaws were found in the way Firefox processed certain malformed web
  content. A webpage containing malicious content could cause Firefox to
  crash, or potentially execute arbitrary code as the user running Firefox.
  (CVE-2008-0412, CVE-2008-0413, CVE-2008-0415, CVE-2008-0419)
  
  Several flaws were found in the way Firefox displayed malformed web
  content. A webpage containing specially-crafted content could trick a user
  into surrendering sensitive information. (CVE-2008-0591, CVE-2008-0593)
  
  A flaw was found in the way Firefox stored password data. If a user saves
  login information for a malicious website, it could be possible to corrupt
  the password database, preventing the user from properly accessing saved
  password data. (CVE-2008-0417)
  
  A flaw was found in the way Firefox handles certain chrome URLs. If a user
  has certain extensions installed, it could allow a malicious website to
  steal sensitive session data. Note: this flaw does not affect a default
  installation of Firefox. (CVE-2008-0418)
  
  A flaw was found in the way Firefox saves certain text files. If a
  website offers a file of type &quot;plain/text&quot;, rather than &quot;text/plain&quot;,
  Firefox will not show future &quot;text/plain&quot; content to the user in the
  browser, forcing them to save those files locally to view the content.
  (CVE-2008-0592) 
  
  Users of firefox are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  firefox on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-February/014664.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~1.5.0.12~0.10.el4.centos", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}