#
#VID 71597e3e-f6b8-11dd-94d9-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 71597e3e-f6b8-11dd-94d9-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63358);
 script_cve_id("CVE-2008-5918", "CVE-2008-5919", "CVE-2009-0240");
 script_version ("$");
 name["english"] = "FreeBSD Ports: websvn";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: websvn

CVE-2008-5918
Cross-site scripting (XSS) vulnerability in the
getParameterisedSelfUrl function in index.php in WebSVN 2.0 and
earlier allows remote attackers to inject arbitrary web script or HTML
via the PATH_INFO.

CVE-2008-5919
Directory traversal vulnerability in rss.php in WebSVN 2.0 and
earlier, when magic_quotes_gpc is disabled, allows remote attackers to
overwrite arbitrary files via directory traversal sequences in the rev
parameter.

CVE-2009-0240
listing.php in WebSVN 2.0 and possibly 1.7 beta, when using an SVN
authz file, allows remote authenticated users to read changelogs or
diffs for restricted projects via a modified repname parameter.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/32338/
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=512191
http://www.gulftech.org/?node=research&article_id=00132-10202008
http://www.vuxml.org/freebsd/71597e3e-f6b8-11dd-94d9-0030843d3802.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: websvn";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"websvn");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.0")<0) {
    security_note(0, data:"Package websvn version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
