#
#VID 0e1e3789-d87f-11dd-8ecd-00163e000016
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 0e1e3789-d87f-11dd-8ecd-00163e000016
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63091);
 script_cve_id("CVE-2008-3076");
 script_version ("$");
 name["english"] = "FreeBSD Ports: vim, vim-lite, vim-gtk2, vim-gnome";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   vim
   vim-lite
   vim-gtk2
   vim-gnome

CVE-2008-3076
** RESERVED **
This candidate has been reserved by an organization or individual that
will use it when announcing a new security problem.  When the
candidate has been publicized, the details for this candidate will be
provided.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.rdancer.org/vulnerablevim-netrw.html
http://www.rdancer.org/vulnerablevim-netrw.v2.html
http://www.rdancer.org/vulnerablevim-netrw.v5.html
http://www.rdancer.org/vulnerablevim-netrw-credentials-dis.html
http://www.openwall.com/lists/oss-security/2008/10/16/2
http://www.vuxml.org/freebsd/0e1e3789-d87f-11dd-8ecd-00163e000016.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: vim, vim-lite, vim-gtk2, vim-gnome";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"vim");
if(!isnull(bver) && revcomp(a:bver, b:"7.0")>=0 && revcomp(a:bver, b:"7.2")<0) {
    security_note(0, data:"Package vim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"vim-lite");
if(!isnull(bver) && revcomp(a:bver, b:"7.0")>=0 && revcomp(a:bver, b:"7.2")<0) {
    security_note(0, data:"Package vim-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"vim-gtk2");
if(!isnull(bver) && revcomp(a:bver, b:"7.0")>=0 && revcomp(a:bver, b:"7.2")<0) {
    security_note(0, data:"Package vim-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"vim-gnome");
if(!isnull(bver) && revcomp(a:bver, b:"7.0")>=0 && revcomp(a:bver, b:"7.2")<0) {
    security_note(0, data:"Package vim-gnome version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
