#
#VID 65c8ecf9-2adb-11db-a6e2-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57256);
 script_cve_id("CVE-2005-0244", "CVE-2005-0245", "CVE-2005-0246");
 script_version ("$");
 name["english"] = "FreeBSD Ports: postgresql, postgresql-server, ja-postgresql";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   postgresql
   postgresql-server
   ja-postgresql

CVE-2005-0244
PostgreSQL 8.0.0 and earlier allows local users to bypass the EXECUTE
permission check for functions by using the CREATE AGGREGATE command.

CVE-2005-0245
Buffer overflow in gram.y for PostgreSQL 8.0.0 and earlier may allow
attackers to execute arbitrary code via a large number of arguments to
a refcursor function (gram.y), which leads to a heap-based buffer
overflow, a different vulnerability than CVE-2005-0247.

CVE-2005-0246
The intagg contrib module for PostgreSQL 8.0.0 and earlier allows
attackers to cause a denial of service (crash) via crafted arrays.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/12948
http://www.vuxml.org/freebsd/65c8ecf9-2adb-11db-a6e2-000e0c2e438a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: postgresql, postgresql-server, ja-postgresql";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"7.2")>=0 && revcomp(a:bver, b:"7.2.7")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.3")>=0 && revcomp(a:bver, b:"7.3.9")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>=0 && revcomp(a:bver, b:"7.4.7")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.0.0")>=0 && revcomp(a:bver, b:"8.0.1")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"postgresql-server");
if(!isnull(bver) && revcomp(a:bver, b:"7.2")>=0 && revcomp(a:bver, b:"7.2.7")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.3")>=0 && revcomp(a:bver, b:"7.3.9")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>=0 && revcomp(a:bver, b:"7.4.7")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.0.0")>=0 && revcomp(a:bver, b:"8.0.1")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"7.2")>=0 && revcomp(a:bver, b:"7.2.7")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.3")>=0 && revcomp(a:bver, b:"7.3.9")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>=0 && revcomp(a:bver, b:"7.4.7")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8.0.0")>=0 && revcomp(a:bver, b:"8.0.1")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
