#
#VID 1a448eb7-6988-11d8-873f-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52502);
 script_cve_id("CVE-2003-0973");
 script_bugtraq_id(9129);
 script_version ("$");
 name["english"] = "FreeBSD Ports: mod_python";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mod_python

CVE-2003-0973
Unknown vulnerability in mod_python 3.0.x before 3.0.4, and 2.7.x
before 2.7.9, allows remote attackers to cause a denial of service
(httpd crash) via a certain query string.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.modpython.org/pipermail/mod_python/2003-November/014532.html
http://www.modpython.org/pipermail/mod_python/2004-January/014879.html
http://www.vuxml.org/freebsd/1a448eb7-6988-11d8-873f-0020ed76ef5a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: mod_python";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mod_python");
if(!isnull(bver) && revcomp(a:bver, b:"2.7")>=0 && revcomp(a:bver, b:"2.7.10")<0) {
    security_note(0, data:"Package mod_python version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"3.0")>=0 && revcomp(a:bver, b:"3.0.4")<0) {
    security_note(0, data:"Package mod_python version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
