#
#VID 0512b761-70fb-40d3-9954-aa4565528fa8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53080);
 script_cve_id("CVE-2005-0011");
 script_version ("$");
 name["english"] = "FreeBSD Ports: kdeedu";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: kdeedu

CVE-2005-0011
Multiple vulnerabilities in fliccd, when installed setuid root as part
of the kdeedu Kstars support for Instrument Neutral Distributed
Interface (INDI) in KDE 3.3 to 3.3.2, allow local users and remote
attackers to execute arbitrary code via stack-based buffer overflows.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.kde.org/info/security/advisory-20050215-1.txt
http://www.vuxml.org/freebsd/0512b761-70fb-40d3-9954-aa4565528fa8.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: kdeedu";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"kdeedu");
if(!isnull(bver) && revcomp(a:bver, b:"3.3.2_1")<0) {
    security_note(0, data:"Package kdeedu version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
