#
#VID 20b4f284-2bfc-11de-bdeb-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 20b4f284-2bfc-11de-bdeb-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63862);
 script_cve_id("CVE-2009-0946");
 script_version ("$");
 name["english"] = "FreeBSD Ports: freetype2";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: freetype2

CVE-2009-0946
Multiple integer overflows in FreeType 2.3.9 and earlier allow remote
attackers to execute arbitrary code via vectors related to large
values in certain inputs in (1) smooth/ftsmooth.c, (2) sfnt/ttcmap.c,
and (3) cff/cffload.c.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/34723/
http://www.vuxml.org/freebsd/20b4f284-2bfc-11de-bdeb-0030843d3802.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: freetype2";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"freetype2");
if(!isnull(bver) && revcomp(a:bver, b:"2.3.9_1")<0) {
    security_note(0, data:"Package freetype2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
