# kst-gpl
#
# (C) Tenable Network Security, Inc. based on work by Michel Arboi <mikhail@nessus.org>
#
# This script is released under the GPLv2
#

if(description)
{
 script_id(80059);;
 script_version ("$Revision: 1.5 $");
 script_name(english: "Firewall Enabled");

 desc = "
Synopsis :

The remote host is behind a firewall

Description :

Based on the responses obtained by the TCP scanner, it was possible to
determine that the remote host seems to be protected by a 
firewall.

Solution :

None

Risk factor : 

None";

 script_description(english:desc);
 script_summary(english: "Determines if the remote host is behind a firewall");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security / Michel Arboi");
 script_family(english: "Firewalls");
 #
 # This plugin only works if openvas_tcp_scanner has run
 #
 script_require_keys("Host/scanners/openvas_tcp_scanner");
 exit(0);
}
include("global_settings.inc");

if ( report_paranoia < 2 ) exit(0);
if ( ! get_kb_item("Host/scanners/nessus_tcp_scanner") ) exit(0);

open = int(get_kb_item("TCPScanner/OpenPortsNb"));
closed = int(get_kb_item("TCPScanner/ClosedPortsNb"));
filtered = int(get_kb_item("TCPScanner/FilteredPortsNb"));

total = open + closed + filtered;

if (total == 0) exit(0);
if (filtered == 0 ) exit(0);
if ( get_kb_item("TCPScanner/RSTRateLimit") ) exit(0);

if ( filtered > ( closed * 4 ) )
{
	security_note(0);
	set_kb_item(name:"Host/firewalled", value:TRUE);
}
