# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3875 (firefox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63882);
 script_cve_id("CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305", "CVE-2009-0652", "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309", "CVE-2009-1310", "CVE-2009-1311", "CVE-2009-1312");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-3875 (firefox)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to firefox
announced via advisory FEDORA-2009-3875.

Update Information:

http://www.mozilla.org/security/known-
vulnerabilities/firefox30.html#firefox3.0.9
ChangeLog:

* Tue Apr 21 2009 Christopher Aillon  - 3.0.9-1
- Update to 3.0.9
* Fri Mar 27 2009 Christopher Aillon  - 3.0.8-1
- Update to 3.0.8

References:

[ 1 ] Bug #496252 - CVE-2009-1302 Firefox 3 Layout engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=496252
[ 2 ] Bug #496253 - CVE-2009-1303 Firefox 2 and 3 Layout engine crash
https://bugzilla.redhat.com/show_bug.cgi?id=496253
[ 3 ] Bug #496255 - CVE-2009-1304 Firefox 3 JavaScript engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=496255
[ 4 ] Bug #496256 - CVE-2009-1305 Firefox 2 and 3 JavaScript engine crash
https://bugzilla.redhat.com/show_bug.cgi?id=496256
[ 5 ] Bug #486704 - CVE-2009-0652 firefox: does not properly prevent the literal rendering of homoglyph characters in IDN domain names (spoof URLs and conduct phishing attacks)
https://bugzilla.redhat.com/show_bug.cgi?id=486704
[ 6 ] Bug #496262 - CVE-2009-1306 Firefox jar: scheme ignores the content-disposition: header on the inner URI
https://bugzilla.redhat.com/show_bug.cgi?id=496262
[ 7 ] Bug #496263 - CVE-2009-1307 Firefox Same-origin violations when Adobe Flash loaded via view-source: protocol
https://bugzilla.redhat.com/show_bug.cgi?id=496263
[ 8 ] Bug #496266 - CVE-2009-1308 Firefox XSS hazard using third-party stylesheets and XBL bindings
https://bugzilla.redhat.com/show_bug.cgi?id=496266
[ 9 ] Bug #496267 - CVE-2009-1309 Firefox Same-origin violations in XMLHttpRequest and XPCNativeWrapper.toString
https://bugzilla.redhat.com/show_bug.cgi?id=496267
[ 10 ] Bug #496270 - CVE-2009-1310 Firefox Malicious search plugins can inject code into arbitrary sites
https://bugzilla.redhat.com/show_bug.cgi?id=496270
[ 11 ] Bug #496271 - CVE-2009-1311 Firefox POST data sent to wrong site when saving web page with embedded frame
https://bugzilla.redhat.com/show_bug.cgi?id=496271
[ 12 ] Bug #496274 - CVE-2009-1312 Firefox allows Refresh header to redirect to javascript: URIs
https://bugzilla.redhat.com/show_bug.cgi?id=496274

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update firefox' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3875

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-3875 (firefox)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.9~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.9~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
