# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3003 (compiz-fusion)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63669);
 script_cve_id("CVE-2008-6514");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-3003 (compiz-fusion)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to compiz-fusion
announced via advisory FEDORA-2009-3003.

Update Information:

This update fixes a security issue in the expo plugin which allows local users
with physical access to drag the screen saver aside and access the locked
desktop by using Expo mouse shortcuts.
ChangeLog:

* Tue Mar 24 2009 Adel Gadllah  0.7.6-6
- Add fix for RH #491918, CVE-2008-6514
* Sat Mar 14 2009 Adel Gadllah  0.7.6-5
- Backport upstream fix for RH #474741

References:

[ 1 ] Bug #491918 - CVE-2008-6514 compiz-fusion: Possible locked desktop access by using Expo plugin mouse shortcuts
https://bugzilla.redhat.com/show_bug.cgi?id=491918

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update compiz-fusion' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3003

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-3003 (compiz-fusion)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"compiz-fusion", rpm:"compiz-fusion~0.7.6~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compiz-fusion-devel", rpm:"compiz-fusion-devel~0.7.6~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compiz-fusion-gnome", rpm:"compiz-fusion-gnome~0.7.6~6.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compiz-fusion-debuginfo", rpm:"compiz-fusion-debuginfo~0.7.6~6.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
