# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0816 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63290);
 script_cve_id("CVE-2009-0029", "CVE-2009-0065", "CVE-2008-5079", "CVE-2008-3528", "CVE-2008-3525", "CVE-2008-3831", "CVE-2008-2750");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-0816 (kernel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kernel
announced via advisory FEDORA-2009-0816.

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system: memory allocation, process allocation, device
input and output, etc.

Update Information:

Update to kernel 2.6.27.12:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.10
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.11
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.27.12

Includes security fixes:
CVE-2009-0029 Linux Kernel insecure 64 bit system call argument passing
CVE-2009-0065 kernel: sctp: memory overflow when FWD-TSN chunk is
received with bad stream ID
Also fixes bug 478299, reported against Fedora 10:
AVC denials on kernel 2.6.27.9-159.fc10.x86_64

Reverts ALSA driver to the version that is upstream in kernel 2.6.27.
This should fix lack of audio on headphone outputs for some notebooks.

ChangeLog:

* Mon Jan 19 2009 Chuck Ebbert  2.6.27.12-78.2.8
- Fix CVE-2009-0065: SCTP buffer overflow
* Mon Jan 19 2009 Chuck Ebbert  2.6.27.12-78.2.5
- Revert ALSA to what is upstream in 2.6.27.
* Mon Jan 19 2009 Kyle McMartin  2.6.27.12-78.2.4
- Linux 2.6.27.12
* Mon Jan 19 2009 Kyle McMartin 
- Roll in xen changes to execshield diff as in later kernels.
(harmless on F-9 as xen was still seperate.)
* Mon Jan 19 2009 Kyle McMartin 
- execshield fixes: should no longer generate spurious handled GPFs,
fixes randomization of executables. also some clean ups.
* Fri Jan 16 2009 Chuck Ebbert  2.6.27.12-78.2.3.rc2
- Linux 2.6.27.12-rc2

References:

[ 1 ] Bug #480864 - CVE-2009-0029 Linux Kernel insecure 64 bit system call argument passing [F9]
https://bugzilla.redhat.com/show_bug.cgi?id=480864
[ 2 ] Bug #480861 - CVE-2009-0065 kernel: sctp: memory overflow when FWD-TSN chunk is received with bad stream ID [F9]
https://bugzilla.redhat.com/show_bug.cgi?id=480861

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0816

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-0816 (kernel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-devel", rpm:"kernel-kdump-devel~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump-debuginfo", rpm:"kernel-kdump-debuginfo~2.6.27.12~78.2.8.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
