# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 973-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56281);
 script_cve_id("CVE-2005-3893", "CVE-2005-3894", "CVE-2005-3895");
 script_bugtraq_id(15537);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 973-1 (otrs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to otrs
announced via advisory DSA 973-1.

Several vulnerabilities have been discovered in otrs, the Open Ticket
Request System, that can be exploited remotely.  The Common
vulnerabilities and Exposures Project identifies the following
problems:

CVE-2005-3893
Multiple SQL injection vulnerabilities allow remote attackers to
execute arbitrary SQL commands and bypass authentication.

CVE-2005-3894
Multiple cross-site scripting vulnerabilities allow remote
authenticated users to inject arbitrary web script or HTML.

CVE-2005-3895
Internally attached text/html mails are rendered as HTML when the
queue moderator attempts to download the attachment, which allows
remote attackers to execute arbitrary web script or HTML.

the old stable distribution (woody) does not contain OTRS packages.

For the stable distribution (sarge) these problems have been fixed in
version 1.3.2p01-6.

For the unstable distribution (sid) these problems have been fixed in
version 2.0.4p01-1.

We recommend that you upgrade your otrs package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20973-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 973-1 (otrs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"otrs-doc-de", ver:"1.3.2p01-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"otrs-doc-en", ver:"1.3.2p01-6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"otrs", ver:"1.3.2p01-6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
