# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 904-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55900);
 script_bugtraq_id(15514);
 script_cve_id("CVE-2005-3632");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 904-1 (netpbm-free)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to netpbm-free
announced via advisory DSA 904-1.

Greg Roelofs discovered and fixed several buffer overflows in pnmtopng
which is also included in netpbm, a collection of graphic conversion
utilities, that can lead to the execution of arbitrary code via a
specially crafted PNM file.

For the old stable distribution (woody) these problems have been fixed in
version 9.20-8.5.

For the stable distribution (sarge) these problems have been fixed in
version 10.0-8sarge2.

For the unstable distribution (sid) these problems will be fixed in
version 10.0-11.

We recommend that you upgrade your netpbm package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20904-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 904-1 (netpbm-free)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnetpbm9", ver:"9.20-8.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm9-dev", ver:"9.20-8.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netpbm", ver:"9.20-8.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm10", ver:"10.0-8sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm10-dev", ver:"10.0-8sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm9", ver:"10.0-8sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm9-dev", ver:"10.0-8sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netpbm", ver:"10.0-8sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
